IF EXISTS (SELECT
						 *
					 FROM
						 sys.views
					 WHERE
						object_id = OBJECT_ID(N'[dbo].[V_PG_FORN_CADASTRO]'))
	DROP VIEW [dbo].[V_PG_FORN_CADASTRO]

GO
GO
CREATE VIEW V_PG_FORN_CADASTRO
AS
SELECT
	PG_FORN.CD_EMP,
	PG_FORN.CD_FORN,
	PG_FORN.NM_FANT,
	PG_FORN.RZ_FORN,
	CASE WHEN ISNULL(PG_FORN.AR_MERCANTIL,0)=0 THEN
		'NAO'
	ELSE
		'SIM'
	END AR_MERCANTIL,
	PG_TP_FORN.DS_TP,
	V_TP_FORN_CLASSIFICACAO.CLASSIFICACAO
FROM
PG_FORN INNER JOIN  PG_TP_FORN ON 
PG_FORN.CD_EMP = PG_TP_FORN.CD_EMP AND 
PG_FORN.CD_TP_FORN = PG_TP_FORN.CD_TP_FORN
INNER JOIN V_TP_FORN_CLASSIFICACAO ON
PG_TP_FORN.TP_FORN = V_TP_FORN_CLASSIFICACAO.TP_FORN

